/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh;

import com.sshtools.j2ssh.sftp.SftpFile;
import java.io.File;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class DirectoryOperation {
    Vector unchangedFiles = new Vector();
    Vector newFiles = new Vector();
    Vector updatedFiles = new Vector();
    Vector deletedFiles = new Vector();
    Vector recursedDirectories = new Vector();

    protected void addNewFile(File file) {
        this.newFiles.add(file);
    }

    protected void addUpdatedFile(File file) {
        this.updatedFiles.add(file);
    }

    protected void addDeletedFile(File file) {
        this.deletedFiles.add(file);
    }

    protected void addUnchangedFile(File file) {
        this.unchangedFiles.add(file);
    }

    protected void addNewFile(SftpFile sftpFile) {
        this.newFiles.add(sftpFile);
    }

    protected void addUpdatedFile(SftpFile sftpFile) {
        this.updatedFiles.add(sftpFile);
    }

    protected void addDeletedFile(SftpFile sftpFile) {
        this.deletedFiles.add(sftpFile);
    }

    protected void addUnchangedFile(SftpFile sftpFile) {
        this.unchangedFiles.add(sftpFile);
    }

    public List getNewFiles() {
        return this.newFiles;
    }

    public List getUpdatedFiles() {
        return this.updatedFiles;
    }

    public List getUnchangedFiles() {
        return this.unchangedFiles;
    }

    public List getDeletedFiles() {
        return this.deletedFiles;
    }

    public boolean containsFile(File file) {
        return this.unchangedFiles.contains(file) || this.newFiles.contains(file) || this.updatedFiles.contains(file) || this.deletedFiles.contains(file) || this.recursedDirectories.contains(file);
    }

    public boolean containsFile(SftpFile sftpFile) {
        return this.unchangedFiles.contains(sftpFile) || this.newFiles.contains(sftpFile) || this.updatedFiles.contains(sftpFile) || this.deletedFiles.contains(sftpFile) || this.recursedDirectories.contains(sftpFile.getAbsolutePath());
    }

    public void addDirectoryOperation(DirectoryOperation directoryOperation, File file) {
        this.updatedFiles.addAll(directoryOperation.getUpdatedFiles());
        this.newFiles.addAll(directoryOperation.getNewFiles());
        this.unchangedFiles.addAll(directoryOperation.getUnchangedFiles());
        this.deletedFiles.addAll(directoryOperation.getDeletedFiles());
        this.recursedDirectories.add(file);
    }

    public int getFileCount() {
        return this.newFiles.size() + this.updatedFiles.size();
    }

    public void addDirectoryOperation(DirectoryOperation directoryOperation, String string) {
        this.updatedFiles.addAll(directoryOperation.getUpdatedFiles());
        this.newFiles.addAll(directoryOperation.getNewFiles());
        this.unchangedFiles.addAll(directoryOperation.getUnchangedFiles());
        this.deletedFiles.addAll(directoryOperation.getDeletedFiles());
        this.recursedDirectories.add(string);
    }

    public long getTransferSize() {
        SftpFile sftpFile;
        File file;
        Object e;
        long l = 0L;
        Iterator iterator = this.newFiles.iterator();
        while (iterator.hasNext()) {
            e = iterator.next();
            if (e instanceof File) {
                file = (File)e;
                if (!file.isFile()) continue;
                l += file.length();
                continue;
            }
            if (!(e instanceof SftpFile) || !(sftpFile = (SftpFile)e).isFile()) continue;
            l += sftpFile.getAttributes().getSize().longValue();
        }
        Iterator iterator2 = this.updatedFiles.iterator();
        while (iterator2.hasNext()) {
            e = iterator2.next();
            if (e instanceof File) {
                file = (File)e;
                if (!file.isFile()) continue;
                l += file.length();
                continue;
            }
            if (!(e instanceof SftpFile) || !(sftpFile = (SftpFile)e).isFile()) continue;
            l += sftpFile.getAttributes().getSize().longValue();
        }
        return l;
    }
}

