<?php
require_once ("tenpay_classes/RequestHandler.class.php");

function tenpay_config() {
    $configarray = array(
     "FriendlyName" => array("Type" => "System", "Value"=>"财付通全能接口 v1.0"),
     "T" => array("FriendlyName" => "交易模式", "Type" => "dropdown", "Options" => "1,2,3","Description" =>"交易模式:  即时到帐[1] 担保交易[2] 客户选择双功能 [3] ", ),
     "partner" => array("FriendlyName" => "卖家财付通商户号ID", "Type" => "text", "Size" => "25","Description" => "财付通商家后台的商户号 10位的", ),
     "key" => array("FriendlyName" => "安全密钥", "Type" => "text", "Size" => "50", "Description" => "到商家后台查找,或者开通邮件里",),
     "need_confirm" => array("FriendlyName" => "必须确认收货", "Type" => "yesno",  "Description" => "如果客户使用担保交易的话,是否确认收货才入帐 ", ),
     "return" => array("FriendlyName" => "前台返回页面是否处理数据", "Type" => "yesno",  "Description" => "一般建议使用异步传输处理,但有可能支付宝服务器与你的服务器无法传输,那就需要这个处理了. ", ),
     "debug" => array("FriendlyName" => "调试模式", "Type" => "yesno", "Description" => "调试模式,详细LOG请见[WHMCS]/downloads/tenpay_log.php", ),
    );
	return $configarray;
}

function tenpay_link($params) {
	#支付宝接口配置
	$type=$params['T'];

	$partner        = $params['partner'];
	$key            = $params['key'];
	$debug          = $params["debug"];

	#系统变量
	$companyname = $params['companyname'];
	$systemurl = $params['systemurl'];
	
	$return_url = $systemurl."/modules/gateways/callback/tenpay_return.php";			//显示支付结果页面,*替换成payReturnUrl.php所在路径
	$notify_url = $systemurl."/modules/gateways/callback/tenpay_callback.php";			//支付完成后的回调处理页面,*替换成payNotifyUrl.php所在路径
	$out_trade_no = $params['invoiceid'];
	$order_price = $params['amount'];
	$trade_mode=$type;
	$strDate = date("Ymd");
	$strTime = date("His");
	$total_fee = $order_price*100;
	$subject ="$companyname 订单[ $out_trade_no ]";
	$desc = "$companyname 订单[ $out_trade_no ]\r\n".$params["description"];
	
	/* 创建支付请求对象 */
	$reqHandler = new RequestHandler();
	$reqHandler->init();
	$reqHandler->setKey($key);
	$reqHandler->setGateUrl("https://gw.tenpay.com/gateway/pay.htm");
	
	//----------------------------------------
	//设置支付参数 
	//----------------------------------------
	$reqHandler->setParameter("partner", $partner);
	$reqHandler->setParameter("out_trade_no", $out_trade_no);
	$reqHandler->setParameter("total_fee", $total_fee);  //总金额
	$reqHandler->setParameter("return_url", $return_url);
	$reqHandler->setParameter("notify_url", $notify_url);
	$reqHandler->setParameter("body", $desc);
	$reqHandler->setParameter("bank_type", "DEFAULT");  	  //银行类型，默认为财付通
	//用户ip
	$reqHandler->setParameter("spbill_create_ip", $_SERVER['REMOTE_ADDR']);//客户端IP
	$reqHandler->setParameter("fee_type", "1");               //币种
	$reqHandler->setParameter("subject",$subject);          //商品名称，（中介交易时必填）
	
	//系统可选参数
	$reqHandler->setParameter("sign_type", "MD5");  	 	  //签名方式，默认为MD5，可选RSA
	$reqHandler->setParameter("service_version", "1.0"); 	  //接口版本号
	$reqHandler->setParameter("input_charset", "utf-8");   	  //字符集
	$reqHandler->setParameter("sign_key_index", "1");    	  //密钥序号
	
	//业务可选参数
	$reqHandler->setParameter("attach", "");             	  //附件数据，原样返回就可以了
	$reqHandler->setParameter("product_fee", "");        	  //商品费用
	$reqHandler->setParameter("transport_fee", "0");      	  //物流费用
	$reqHandler->setParameter("time_start", date("YmdHis"));  //订单生成时间
	$reqHandler->setParameter("time_expire", "");             //订单失效时间
	$reqHandler->setParameter("buyer_id", "");                //买方财付通帐号
	$reqHandler->setParameter("goods_tag", "");               //商品标记
	$reqHandler->setParameter("trade_mode",$trade_mode);      //交易模式（1.即时到帐模式，2.中介担保模式，3.后台选择（卖家进入支付中心列表选择））
	$reqHandler->setParameter("transport_desc","");           //物流说明
	$reqHandler->setParameter("trans_type","1");              //交易类型
	$reqHandler->setParameter("agentid","");                  //平台ID
	$reqHandler->setParameter("agent_type","");               //代理模式（0.无代理，1.表示卡易售模式，2.表示网店模式）
	$reqHandler->setParameter("seller_id","");                //卖家的商户号

	
	//请求的URL
	$reqUrl = $reqHandler->getRequestURL();
	
	//获取debug信息,建议把请求和debug信息写入日志，方便定位问题
	/**/
	if ($debug) {
		$debugInfo = $reqHandler->getDebugInfo();
		logResult2($debugInfo);
	}
	$link="<form action='".$reqHandler->getGateUrl()."' id='tenpaysubmit' method='post' >\n";
	$params = $reqHandler->getAllParameters();
	foreach($params as $k => $v) {
		$link.="<input type=\"hidden\" name=\"{$k}\" value=\"{$v}\" />\n";
	}
	//$link=$reqHadler->getRequestURL();
	$img=$systemurl."/modules/gateways/callback/cft.gif";
	$code=$link."</form><a href='#' onclick=\"document.forms['tenpaysubmit'].submit();\"><img src='$img' alt='点击使用财付通支付'></a>";
	if ($debug) {
		$msg="订单: $invoiceid 生成支付表单 $code";
		logResult2($msg);
	}
	return $code;
}
function logResult2($word='',$file="../../downloads/tenpay_log.php") {
	$fp = fopen($file,"a");
	flock($fp, LOCK_EX) ;
	fwrite($fp,"执行日期：".strftime("%Y%m%d%H%M%S",time())." <?php die() ?>\n".$word."\n");
	flock($fp, LOCK_UN);
	fclose($fp);
}
?>