<?php
$PP=$_POST;
include("../../../dbconnect.php");
include("../../../includes/functions.php");
include("../../../includes/gatewayfunctions.php");
include("../../../includes/invoicefunctions.php");
require_once ("../tenpay_classes/ResponseHandler.class.php");
require_once ("../tenpay_classes/RequestHandler.class.php");
require_once ("../tenpay_classes/client/ClientResponseHandler.class.php");
require_once ("../tenpay_classes/client/TenpayHttpClient.class.php");
$gatewaymodule = "tenpay"; 
$GATEWAY = getGatewayVariables($gatewaymodule);
if (!$GATEWAY["type"]) die("Module Not Activated"); # Checks gateway module is active before accepting callback
$need_confirm=$GATEWAY['need_confirm'];
$debug=$GATEWAY['debug'];
$key=$GATEWAY['key'];
$partner=$GATEWAY['partner'];


if ($debug) logResult(serialize($PP));

/* 创建支付应答对象 */
$resHandler = new ResponseHandler();
$resHandler->setKey($key);

$out_trade_no = $resHandler->getParameter("out_trade_no");
$transaction_id = $resHandler->getParameter("transaction_id");

$invoiceid = checkCbInvoiceID($out_trade_no,$GATEWAY["name"]); # Checks invoice ID is a valid invoice number or ends processing
checkCbTransID($transaction_id);
logTransaction($GATEWAY["name"],$PP,"INFO2");


//判断签名
if($resHandler->isTenpaySign()==false) { //签名失败
	logTransaction($GATEWAY["name"],$PP,"Unsuccessful-signfalse");
	if ($debug) logResult($resHandler->getDebugInfo());
	exit;
}
$out_trade_no = $resHandler->getParameter("out_trade_no");
$transaction_id = $resHandler->getParameter("transaction_id");
$total_fee = $resHandler->getParameter("total_fee");
$discount = $resHandler->getParameter("discount");
$notify_id = $resHandler->getParameter("notify_id");
if ($debug) logResult("得到通知ID: $notify_id" );
$queryReq = new RequestHandler();
$queryReq->init();
$queryReq->setKey($key);
$queryReq->setGateUrl("https://gw.tenpay.com/gateway/simpleverifynotifyid.xml");
$queryReq->setParameter("partner", $partner);
$queryReq->setParameter("notify_id", $notify_id);
		
$httpClient = new TenpayHttpClient();
$httpClient->setTimeOut(5);
$httpClient->setReqContent($queryReq->getRequestURL());
$ok=false;
//后台调用
if($httpClient->call()) {
	//设置结果参数
	$queryRes = new ClientResponseHandler();
	$queryRes->setContent($httpClient->getResContent());
	$queryRes->setKey($key);
	if ($debug){
		$msg="<br>------------------------------------------------------<br>";
		$msg.="http res:" . $httpClient->getResponseCode() . "," . $httpClient->getErrInfo() . "<br>";
		$msg.="query req:" . htmlentities($queryReq->getRequestURL(), ENT_NOQUOTES, "GB2312") . "<br><br>";
		$msg.="query res:" . htmlentities($queryRes->getContent(), ENT_NOQUOTES, "GB2312") . "<br><br>";
		$msg.="query reqdebug:" . $queryReq->getDebugInfo() . "<br><br>" ;
		$msg.="query resdebug:" . $queryRes->getDebugInfo() . "<br><br>";
		logResult($msg);
	}
	
	if($resHandler->getParameter("trade_mode") == "1"){
	//判断签名及结果（即时到帐）
	//只有签名正确,retcode为0，trade_state为0才是支付成功
		if($queryRes->isTenpaySign() && $queryRes->getParameter("retcode") == "0" && $resHandler->getParameter("trade_state") == "0") {
			if ($debug) logResult("即时到帐验签ID成功");
			$ok=true;
		} else {
		  if ($debug)logResult("即时到帐后台回调失败");
		  logTransaction($GATEWAY["name"],$PP,"Unsuccessful-TEN-NOTIFY");
		  exit;
		}
	}elseif ($resHandler->getParameter("trade_mode") == "2")
	{
  //判断签名及结果（中介担保）
	//只有签名正确,retcode为0，trade_state为0才是支付成功
		if($queryRes->isTenpaySign() && $queryRes->getParameter("retcode") == "0" ) 
		{
			logResult("中介担保验签ID成功");
			//处理业务开始
			if ($debug) logResult("中介担保后台回调，trade_state=".$resHandler->getParameter("trade_state"));
			switch ($resHandler->getParameter("trade_state")) {
				case "0":	//付款成功
							if (!$need_confirm) $ok=true;
							break;
				case "1":	//交易创建
							break;
				case "2":	//收获地址填写完毕
							break;
				case "4":	//卖家发货成功
							if (!$need_confirm) $ok=true;
							break;
				case "5":	//买家收货确认，交易成功
							$ok=true;
							break;
				case "6":	//交易关闭，未完成超时关闭
							break;
				case "7":	//修改交易价格成功
							break;
				case "8":	//买家发起退款
							break;
				case "9":	//退款成功
							break;
				case "10":	//退款关闭			
							break;
				default:
							break;
			}
		} else
		{
		 	if ($debug) logResult("中介担保后台回调失败");
			exit;
		}
	}
		
}else
{
	//通信失败
	logTransaction($GATEWAY["name"],$PP,"Unsuccessful-checkfalse");
	if ($debug){
		$msg="call err:" . $httpClient->getResponseCode() ."," . $httpClient->getErrInfo() . " ";
		logResult($msg);
	}
} 
if ($ok){
	//入帐
	$fee=0;
	addInvoicePayment($out_trade_no,$transaction_id,$total_fee,$fee,$gatewaymodule);
	logTransaction($GATEWAY["name"],$PP,"Successful-TEN-NOTIFY");
	if ($debug) logResult("订单 $invoiceid  入帐成功.");	
}
?>